using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

namespace jp.co.knowlbo.TimeView.Appearance
{
	/// <summary>
	/// SecondForm ̊Tv̐łB
	/// </summary>
	public class SecondForm : System.Windows.Forms.Form
	{
		private System.Windows.Forms.Label lblCaption;
		private System.Windows.Forms.Button cmdCoolNo1;
		private System.Windows.Forms.Button cmdCoolNo2;
		private System.Windows.Forms.Button cmdSecondForm;
		private System.Windows.Forms.Button cmdPreview;
		/// <summary>
		/// KvȃfUCiϐłB
		/// </summary>
		private System.ComponentModel.Container components = null;
		
		private enum vtTempleteKey{Pattern1 = 1, Pattern2 = 2, Pattern3 = 3}
		private ArrayList pList = new ArrayList();
		private AxKnTViewLib.AxKnTView axKnTView1;
	
		private struct Schedule
		{
			public int TaskIndex;
			public DateTime Start;
			public DateTime Finish;
			public float Progress;
		}
		private Schedule sch;

		public SecondForm()
		{
			//
			// Windows tH[ fUCi T|[gɕKvłB
			//
			InitializeComponent();

			//
			// TODO: InitializeComponent ĂяǒɁARXgN^ R[hǉĂB
			//
		}

		/// <summary>
		/// gpĂ郊\[XɌ㏈s܂B
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// fUCi T|[gɕKvȃ\bhłB̃\bh̓e
		/// R[h GfB^ŕύXȂłB
		/// </summary>
		private void InitializeComponent()
		{
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(SecondForm));
			this.lblCaption = new System.Windows.Forms.Label();
			this.cmdCoolNo1 = new System.Windows.Forms.Button();
			this.cmdCoolNo2 = new System.Windows.Forms.Button();
			this.cmdSecondForm = new System.Windows.Forms.Button();
			this.cmdPreview = new System.Windows.Forms.Button();
			this.axKnTView1 = new AxKnTViewLib.AxKnTView();
			((System.ComponentModel.ISupportInitialize)(this.axKnTView1)).BeginInit();
			this.SuspendLayout();
			// 
			// lblCaption
			// 
			this.lblCaption.Location = new System.Drawing.Point(16, 8);
			this.lblCaption.Name = "lblCaption";
			this.lblCaption.Size = new System.Drawing.Size(560, 40);
			this.lblCaption.TabIndex = 1;
			this.lblCaption.Text = "ev[g@\𗘗pāAMainFormƓ菭ȂR[fBOŎĂ܂B";
			// 
			// cmdCoolNo1
			// 
			this.cmdCoolNo1.Anchor = (System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right);
			this.cmdCoolNo1.Location = new System.Drawing.Point(504, 64);
			this.cmdCoolNo1.Name = "cmdCoolNo1";
			this.cmdCoolNo1.Size = new System.Drawing.Size(80, 32);
			this.cmdCoolNo1.TabIndex = 3;
			this.cmdCoolNo1.Text = "Cool No.1";
			this.cmdCoolNo1.Click += new System.EventHandler(this.cmdCoolNo1_Click);
			// 
			// cmdCoolNo2
			// 
			this.cmdCoolNo2.Anchor = (System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right);
			this.cmdCoolNo2.Location = new System.Drawing.Point(504, 104);
			this.cmdCoolNo2.Name = "cmdCoolNo2";
			this.cmdCoolNo2.Size = new System.Drawing.Size(80, 32);
			this.cmdCoolNo2.TabIndex = 4;
			this.cmdCoolNo2.Text = "Cool No.2";
			this.cmdCoolNo2.Click += new System.EventHandler(this.cmdCoolNo2_Click);
			// 
			// cmdSecondForm
			// 
			this.cmdSecondForm.Anchor = (System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right);
			this.cmdSecondForm.Enabled = false;
			this.cmdSecondForm.Location = new System.Drawing.Point(504, 144);
			this.cmdSecondForm.Name = "cmdSecondForm";
			this.cmdSecondForm.Size = new System.Drawing.Size(80, 32);
			this.cmdSecondForm.TabIndex = 5;
			this.cmdSecondForm.Text = "Second Form";
			// 
			// cmdPreview
			// 
			this.cmdPreview.Anchor = (System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right);
			this.cmdPreview.Location = new System.Drawing.Point(504, 208);
			this.cmdPreview.Name = "cmdPreview";
			this.cmdPreview.Size = new System.Drawing.Size(80, 32);
			this.cmdPreview.TabIndex = 6;
			this.cmdPreview.Text = "Print Preview";
			this.cmdPreview.Click += new System.EventHandler(this.cmdPreview_Click);
			// 
			// axKnTView1
			// 
			this.axKnTView1.Anchor = (((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right);
			this.axKnTView1.Location = new System.Drawing.Point(8, 61);
			this.axKnTView1.Name = "axKnTView1";
			this.axKnTView1.OcxState = ((System.Windows.Forms.AxHost.State)(resources.GetObject("axKnTView1.OcxState")));
			this.axKnTView1.Size = new System.Drawing.Size(488, 201);
			this.axKnTView1.TabIndex = 2;
			this.axKnTView1.AfterPieceAdd += new AxKnTViewLib._DKnTViewEvents_AfterPieceAddEventHandler(this.axKnTView1_AfterPieceAdd);
			// 
			// SecondForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 12);
			this.ClientSize = new System.Drawing.Size(592, 270);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.axKnTView1,
																		  this.cmdPreview,
																		  this.cmdSecondForm,
																		  this.cmdCoolNo2,
																		  this.cmdCoolNo1,
																		  this.lblCaption});
			this.Name = "SecondForm";
			this.Text = "^Cr[@|@\Љ|@LxȃAsAX";
			this.Load += new System.EventHandler(this.SecondForm_Load);
			((System.ComponentModel.ISupportInitialize)(this.axKnTView1)).EndInit();
			this.ResumeLayout(false);

		}
		#endregion

		private void SecondForm_Load(object sender, System.EventArgs e)
		{
			axKnTView1.ViewTopTime = "1999/8/5 8:00";

			KnTViewLib.Item itm;
			
			string str;
			char chr;
			for ( int i = 1 ; i < 20 ; i++ )
			{
				//ev[gɂItem̒ǉ
				itm = axKnTView1.Items.AddFromTemplate(1, null, null);
				chr = Convert.ToChar(64 + i);
				str = chr.ToString();
				itm.Cells.Item(1).Value = " " + str;
				itm.Cells.Item(2).Value = "ؿ " + Convert.ToString(i);
			}
			
			LoadSchedule();

			AddPieceTemplate(vtTempleteKey.Pattern1);

		}
		
		private void LoadSchedule()
		{
			sch.TaskIndex = 1;
			sch.Start = Convert.ToDateTime("1999/8/5 9:00");
			sch.Finish = Convert.ToDateTime("1999/8/5 11:00");
			sch.Progress = (float)0.2;
			pList.Add(sch);

			sch.TaskIndex = 2;
			sch.Start = Convert.ToDateTime("1999/8/5 13:00");
			sch.Finish = Convert.ToDateTime("1999/8/5 14:30");
			sch.Progress = (float)0.6;
			pList.Add(sch);

			sch.TaskIndex = 3;
			sch.Start = Convert.ToDateTime("1999/8/5 16:00");
			sch.Finish = Convert.ToDateTime("1999/8/5 17:00");
			sch.Progress = (float)0.7;
			pList.Add(sch);

			sch.TaskIndex = 4;
			sch.Start = Convert.ToDateTime("1999/8/5 9:00");
			sch.Finish = Convert.ToDateTime("1999/8/5 11:00");
			sch.Progress = 1;
			pList.Add(sch);

			sch.TaskIndex = 5;
			sch.Start = Convert.ToDateTime("1999/8/5 10:00");
			sch.Finish = Convert.ToDateTime("1999/8/5 17:00");
			sch.Progress = (float)0.5;
			pList.Add(sch);

			sch.TaskIndex = 6;
			sch.Start = Convert.ToDateTime("1999/8/5 15:00");
			sch.Finish = Convert.ToDateTime("1999/8/5 15:30");
			sch.Progress = (float)0.5;
			pList.Add(sch);

			sch.TaskIndex = 7;
			sch.Start = Convert.ToDateTime("1999/8/5 18:00");
			sch.Finish = Convert.ToDateTime("1999/8/5 20:00");
			sch.Progress = (float)0.5;
			pList.Add(sch);
		}

		private void AddPieceTemplate(vtTempleteKey tk)
		{
			KnTViewLib.Item itm;
			KnTViewLib.Piece pce;
			KnTViewLib.Progress prgrs;
			
			foreach ( Schedule sch in pList )			
			{        
				itm = axKnTView1.Items.Item(sch.TaskIndex);
				
				//ev[gɂPiece̒ǉ
				pce = itm.Pieces.AddFromTemplate(tk, null, null);
//				pce = itm.Pieces.Add(null, null);
				pce.Start = sch.Start;
				pce.Finish = sch.Finish;
				prgrs = pce.Progresses.Item(1);
				prgrs.PercentTo = sch.Progress;
			}
		}
		
		private void axKnTView1_AfterPieceAdd(object sender, AxKnTViewLib._DKnTViewEvents_AfterPieceAddEvent e)
		{
			e.cancel.Value = true;
			
			KnTViewLib.Piece pce;
			pce = e.item.Pieces.Add(null, null);
			pce.Start = e.start;
			pce.Finish = e.finish;
			
			KnTViewLib.Progress prgrs;
			prgrs = pce.Progresses.Add(null, null);
			prgrs.PercentTo = 0.3;
    
			KnTViewLib.PieceCaption pcap;
			pcap = pce.Captions.Add(null, null);
			pcap.Position = KnTViewLib.TivPieceCaptionPosition.tivPieceRight;
			pcap.Type = KnTViewLib.TivPieceCaptionType.tivPieceCaptionProgress1To;
		}

		private void cmdPreview_Click(object sender, System.EventArgs e)
		{
			KnTViewLib.IPrintInfo pi = new KnTViewLib.PrintInfo();
			pi.PaperSize = KnTViewLib.TivPaperSize.tivPaperA4;
			axKnTView1.PrintPreview((KnTViewLib.PrintInfo)pi);
		}
		
		private uint RGB( int red, int green, int blue ) 
		{
			return (uint)(blue << 16 | green << 8 | red);
		}
		
		private void SavePieceInfo()
		{				
			pList.Clear();
			
			foreach (KnTViewLib.Item itm in axKnTView1.Items)
			{
				foreach (KnTViewLib.Piece pce in itm.Pieces)
				{
					sch.Start = Convert.ToDateTime(pce.Start);
					sch.Finish = Convert.ToDateTime(pce.Finish);
					sch.Progress = Convert.ToSingle(pce.Progresses.Item(1).PercentTo);
					sch.TaskIndex = pce.ItemIndex;
					pList.Add(sch);
				}
			}
		}
		
		private void ClearPiece()
		{
			//݂邷ׂĂItemׂ̂ĂPieceNA
			foreach (KnTViewLib.Item itm in axKnTView1.Items)
			{
				itm.Pieces.Clear();
			}
		}

		private void cmdCoolNo1_Click(object sender, System.EventArgs e)
		{
			KnTViewLib.TimeScale tscale;
			KnTViewLib.LetterScale scaleL;
			KnTViewLib.LetterScale scaleM;
			KnTViewLib.LineScale scaleS;
			KnTViewLib.PiecePane pcepane;
		    
			tscale = axKnTView1.TimeScale;
			scaleL = axKnTView1.TimeScale.Large;
			scaleM = axKnTView1.TimeScale.Medium;
			scaleS = axKnTView1.TimeScale.Small;
			pcepane = axKnTView1.PiecePane;
		    
			scaleL.Fill.BackColor = RGB(0, 0, 0);
			scaleL.Color = RGB(156, 206, 255);
			scaleM.Fill.BackColor = RGB(0, 0, 0);
			scaleM.Color = RGB(0, 206, 255);
			scaleS.Fill.BackColor = RGB(0, 0, 0);
			scaleS.Line.Color = RGB(49, 49, 156);
			scaleS.SubLine.Color = RGB(49, 49, 156);
			tscale.BottomBorder.Color = RGB(49, 49, 156);

			pcepane.MediumLine.Style = KnTViewLib.TivLineStyle.tivLineSolid;
			pcepane.MediumLine.Color = RGB(49, 49, 156);
			pcepane.SpecialTimeSet.SpecialTimes.Item(1).Fill.Pattern = KnTViewLib.TivFillPattern.tivPatternForwardDiagonal;
			pcepane.SpecialTimeSet.SpecialTimes.Item(1).Fill.ForeColor = RGB(32, 32, 32);
			
			foreach (KnTViewLib.ColumnHeader ch in axKnTView1.ColumnHeaders)
			{
				ch.Fill.Pattern = KnTViewLib.TivFillPattern.tivPatternNull;
				ch.Fill.BackColor = RGB(0, 0, 0);
				ch.Color = RGB(255, 255, 255);
				ch.BottomBorder.Color = RGB(49, 49, 156);
				ch.RightBorder.Style = KnTViewLib.TivLineStyle.tivLineNull;
			}
		    
			foreach (KnTViewLib.Item itm in axKnTView1.Items)
			{
				if (itm.Index % 5 == 0)
					itm.PiecePane.Fill.BackColor = RGB(0, 0, 64);
				else
					itm.PiecePane.Fill.BackColor = RGB(0, 0, 0);
				
				itm.PiecePane.BottomBorder.Color = RGB(49, 49, 156);

				foreach (KnTViewLib.Cell cel in itm.Cells)
				{
					if ((itm.Index == 3) & (cel.Index == 1))
					{
						cel.Fill.BackColor = RGB(0, 44, 87);
						cel.Fill.ForeColor = RGB(0, 0, 0);
						cel.Fill.Pattern = KnTViewLib.TivFillPattern.tivPatternHorizontalGradation;
					}
					else if ((itm.Index == 6) & (cel.Index == 2))
					{
						cel.Fill.BackColor = RGB(0, 44, 87);
						cel.Fill.ForeColor = RGB(0, 0, 0);
						cel.Fill.Pattern = KnTViewLib.TivFillPattern.tivPatternHorizontalGradation;
					}
					else
					{
						cel.Fill.Pattern = KnTViewLib.TivFillPattern.tivPatternNull;
						cel.Fill.BackColor = RGB(0, 0, 0);
					}
					cel.Color = RGB(255, 255, 255);
					cel.BottomBorder.Color = RGB(49, 49, 156);
					cel.RightBorder.Style = KnTViewLib.TivLineStyle.tivLineNull;
				}
				
				//s[Xۑ
				SavePieceInfo();
				//s[X̃NA
				ClearPiece();
				//s[X̒ǉ
				AddPieceTemplate(vtTempleteKey.Pattern2);
			}
		}
		
		private void cmdCoolNo2_Click(object sender, System.EventArgs e)
		{
			KnTViewLib.TimeScale tscale;
			KnTViewLib.LetterScale scaleL;
			KnTViewLib.LetterScale scaleM;
			KnTViewLib.LineScale scaleS;
			KnTViewLib.PiecePane pcepane;
		    
			tscale = axKnTView1.TimeScale;
			scaleL = axKnTView1.TimeScale.Large;
			scaleM = axKnTView1.TimeScale.Medium;
			scaleS = axKnTView1.TimeScale.Small;
			pcepane = axKnTView1.PiecePane;

			scaleL.Fill.BackColor = RGB(222, 199, 161);
			scaleL.Color = RGB(0, 0, 0);
			scaleM.Fill.BackColor = RGB(222, 199, 161);
			scaleM.Color = RGB(0, 0, 0);
			scaleS.Fill.BackColor = RGB(222, 199, 161);
			scaleS.Line.Color = RGB(0, 0, 0);
			scaleS.SubLine.Color = RGB(0, 0, 0);
			tscale.BottomBorder.Color = RGB(0, 0, 0);

			pcepane.MediumLine.Style = KnTViewLib.TivLineStyle.tivLineNull;
			pcepane.SpecialTimeSet.SpecialTimes.Item(1).Fill.Pattern = KnTViewLib.TivFillPattern.tivPatternDiagonalCross;
			pcepane.SpecialTimeSet.SpecialTimes.Item(1).Fill.ForeColor = RGB(167, 199, 220);
			
			foreach (KnTViewLib.ColumnHeader ch in axKnTView1.ColumnHeaders)
			{
				ch.Fill.Pattern = KnTViewLib.TivFillPattern.tivPattern3D;
				ch.Fill.BackColor = RGB(222, 199, 161);
				ch.Color = RGB(0, 0, 0);
				ch.BottomBorder.Color = RGB(0, 0, 0);
				ch.RightBorder.Style = KnTViewLib.TivLineStyle.tivLineNull;
			}
			
			foreach (KnTViewLib.Item itm in axKnTView1.Items)
			{
				if (itm.Index % 5 == 0)
					itm.PiecePane.Fill.BackColor = RGB(203, 207, 222);
				else
					itm.PiecePane.Fill.BackColor = RGB(224, 226, 231);
				
				itm.PiecePane.BottomBorder.Color = RGB(127, 127, 127);

				foreach (KnTViewLib.Cell cel in itm.Cells)
				{
					cel.Fill.Pattern = KnTViewLib.TivFillPattern.tivPattern3D;
					if ((itm.Index == 3) & (cel.Index == 1))
					{
						cel.Fill.BackColor = RGB(123, 148, 173);
						cel.Color = RGB(0, 0, 64);
					}
					else if ((itm.Index == 6) & (cel.Index == 2))
					{
						cel.Fill.BackColor = RGB(123, 148, 173);
						cel.Color = RGB(0, 0, 64);
					}
					else
					{
						cel.Fill.BackColor = RGB(235, 206, 202);
						cel.Color = RGB(64, 0, 0);
					}
					cel.RightBorder.Color = RGB(127, 127, 127);
					cel.RightBorder.Style = KnTViewLib.TivLineStyle.tivLineSolid;
					cel.BottomBorder.Color = RGB(127, 127, 127);
					cel.BottomBorder.Style = KnTViewLib.TivLineStyle.tivLineSolid;

					//s[Xۑ
					SavePieceInfo();
					//s[X̃NA
					ClearPiece();
					//s[X̒ǉ
					AddPieceTemplate(vtTempleteKey.Pattern3);
				}
			}
		}
	}
}
